/*
	FILE:			bool.h

	DESC:

		Not what you think.  This defines data structures and functions
		to resolve true/false conditions, such as handling "true" as the
		rhs of a configuration variable definition.

	REV:	2011/05/22; File started.


*/


#if !defined(BOOL_H)
#define BOOL_H

#include <local_types.h>

#define TRUE	((u32)1)
#define FALSE	((u32)0)


extern char * true_token_table[];

#define TRUE_TOKEN_TABLE \
	char * true_token_table[] = { "1", "t", "T", "true", "True", "TRUE", "y", "Y", "yes", "Yes", "YES", NULL }


extern char * false_token_table[];

#define FALSE_TOKEN_TABLE \
	char * false_token_table[] = { "0", "f", "F", "false", "False", "FALSE", "n", "N", "no", "No", "NO", NULL }



int str_is_true(char *);
int str_is_false(char *);


#endif  /* BOOL_H */
