#if !defined(PLATFORM_H)
#define PLATFORM_H


#if defined(_GNU_SOURCE)
#define _COLD					__attribute__((cold))
#define _CONSTRUCTOR(n)		__attribute__((constructor(n)))
#define _DESTRUCTOR(n)		__attribute__((destructor(n)))
#define _FAST					__attribute__((fastcall))
#define _HOT					__attribute__((hot))
#define _INTERNAL				__attribute__((visibility("internal")))
#define _NORETURN				__attribute__((noreturn))

#define unlikely(e)			__builtin_expect((!!(e)), 0)
#define likely(e)				__builtin_expect((!!(e)), 1)

#endif


#if !defined(_FAST)
#define _COLD
#define _CONSTRUCTOR(n)
#define _DESTRUCTOR(n)
#define _FAST
#define _HOT
#define _INTERNAL
#define _NORETURN

#define unlikely(e)		(e)
#define likely(e)			(e)

#endif

#endif // EOF
