#if !defined (DEBUGGING_H)

#define DEBUGGING_H

/*
   Simple debugging macros and function prototypes associated
   with abnormal run-time conditions, abnormal termination, and 
	informational messaging.

   die("string literal with formatting", printf_args);
   die_errnno("ditto", args);
   {notice,info,warn,crit,emerg}("message", args...);


*/
#include <local_types.h>
#include <platform.h>

#include <stdio.h>
#include <stdarg.h>
#include <pthread.h>

#define DEBUG_TRACE	0x0001
#define DEBUG_INFO	0x0002
#define DEBUG_FILE	0x0004
#define DEBUG_SOCKET 0x0008
#define DEBUG_MEM		0x0010
#define DEBUG_IO		0x0020
#define DEBUG_LOCK	0x0040
#define DEBUG_CONS	0x0080
#define DEBUG_SWITCH	0x0100
#define DEBUG_CURSES	0x0200
#define DEBUG_LIST	0x0400
#define DEBUG_SIGNAL	0x0800
#define DEBUG_PORT	0x1000
#define DEBUG_THREAD	0x2000
#define DEBUG_SHM		0x4000
#define DEBUG_OFF		0


extern int		debug_mask;
extern int		debug_syslog;
extern FILE *	debug_stream;
extern char *	debug_logfile;




#define notice(s, arg...)			debug(DEBUG_OFF, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)


#define die(s, arg...)	{		\
		notice(s, ##arg);			\
		do_backtrace_and_abt();	\
	}



#if defined (DO_DEBUG)
	#define ret(n)						TRACE("return"); return(n)

	#define INFO(s, arg...)			debug(DEBUG_INFO, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define TRACE(s, arg...)		debug(DEBUG_TRACE, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define FILE(s, arg...)			debug(DEBUG_FILE, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define SOCKET(s, arg...)		debug(DEBUG_SOCKET, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define MEM(s, arg...)			debug(DEBUG_MEM, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define IO(s, arg...)			debug(DEBUG_IO, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define LOCK(s, arg...)			debug(DEBUG_LOCK, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define CONS(s, arg...)			debug(DEBUG_CONS, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define SWITCH(s, arg...)		debug(DEBUG_CURSES, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define LIST(s, arg...)			debug(DEBUG_LIST, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define SIGNAL(s, arg...)		debug(DEBUG_SIGNAL, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define PORT(s, arg...)			debug(DEBUG_PORT, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define THREAD(s, arg...)		debug(DEBUG_THREAD, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
   #define POSIX_SHM(s, arg...)	debug(DEBUG_SHM, "[%lu]%s(): " s, pthread_self(), __func__, ## arg)
#else
	#define ret(n)						return(n)

	#define INFO(s, arg...)
   #define TRACE(s, arg...)
   #define FILE(s, arg...)
   #define SOCKET(s, arg...)
   #define MEM(s, arg...)
   #define IO(s, arg...)
   #define LOCK(s, arg...)
   #define CONS(s, arg...)
   #define SWITCH(s, arg...)
   #define CURSES(s, arg...)
   #define LIST(s, arg...)
   #define SIGNAL(s, arg...)
	#define PORT(s, arg...)
   #define THREAD(s, arg...)
	#define POSIX_SHM(s, arg...)
#endif


void	do_backtrace(void);
void	do_backtrace_and_abt(void);
void	debug(int, char *, ...);

#endif
