/*
   FILE: debugging.c

	DESC:
	
		Convenience functions for logging debug messages to a file,
		stream, or syslog.

	REV: 2011/05/23; Changed to use T/F functions from bool.h
        2010/02/02; More reworking.

*/


#include <debugging.h>
#include <platform.h>
#include <bool.h>

#include <stdlib.h>
#include <string.h>
#include <execinfo.h>
#include <fcntl.h>
#include <pthread.h>
#include <signal.h>
#include <syslog.h>
#include <time.h>
#include <stdarg.h>


int		debug_mask = 0;
FILE *	debug_stream  = NULL;
char *	debug_logfile = NULL;
int		debug_syslog = 0;



void debug_initalization(void)
{
	char *dt_s, *check_stderr;


	if((dt_s = getenv("DEBUG_MASK")))
		debug_mask = strtol(dt_s, NULL, 0);
	else
		debug_mask = 0;

	if(getenv("DEBUG_SYSLOG"))
		debug_syslog = 1;

	debug_stream = stderr;

	check_stderr = getenv("DEBUG_STDERR");
	
	if(check_stderr && str_is_false(check_stderr))
			debug_stream = NULL;

	if((debug_logfile = getenv("DEBUG_LOGFILE"))) {
		if(!(debug_stream = fopen(debug_logfile, "a"))) {
			debug_stream = stderr;
			fprintf(stderr, "%s(): Cannot open logfile: %s", __func__, debug_logfile);
		}
	}
	
	return;
}



void debug_shutdown(void)
{
	if(debug_logfile)
		fclose(debug_stream);

	return;
}




void do_backtrace(void)
{
	pthread_t	self = pthread_self();
	void *buffer[25];
   char **bt;
   int n, i = 0;

   n = backtrace(buffer, 25);
   bt= backtrace_symbols(buffer, n);

 	fprintf(debug_stream, "[%lu] Backtrace follows:\n\n", self);

	while(i < n) {
		fprintf(debug_stream, "[%lu] %s\n", self, bt[i++]);
	}
}


void do_backtrace_and_abt(void)
{
	do_backtrace();

   raise(SIGABRT);
   exit(99);
}



_COLD
void debug(int l, char *format, ...)
{
	va_list	ap;

	va_start(ap, format);
	
	if(debug_mask & l || !l)
		if(debug_stream)
			vfprintf(debug_stream, format, ap);

	if(debug_syslog && (debug_mask & l || !l))
		vsyslog(LOG_NOTICE, format, ap);

	va_end(ap);

	return;
}
