/*
    C main function for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <sys/mman.h>

#include <xenctrl.h>

#include <caml/mlvalues.h>
#include <caml/callback.h>
#include <caml/memory.h>
#include <caml/alloc.h>

int main(int argc, char *argv[], char *envp[])
{
    value *val;

    /* Wait before things might hang up */
    sleep(1);

    caml_startup(argv);
    val = caml_named_value("main");
    if (!val) {
        printf("Couldn't find Caml main");
        return 1;
    }

    caml_callback(*val, Val_int(0));

    return 0;
}
