(* 
    Constants for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

let path_max = 4096
let absolute_path_max = 3072
let relative_path_max = 2048
let payload_max = 4096

(* domain_id_self is used in certain contexts to refer to oneself *)
let domain_id_self = 0x7FF0

(* The prefix character that indicates a watch event *)
let event_char = '@'

let null_char = char_of_int 0
let null_string = String.make 0 null_char
let null_file_descr = - 1

let payload_false = "F"
let payload_true = "T"

let virq_dom_exc = 3

(* Error type *)
type error =
  | EINVAL
  | EACCES
  | EEXIST
  | EISDIR
  | ENOENT
  | ENOMEM
  | ENOSPC
  | EIO
  | ENOTEMPTY
  | ENOSYS
  | EROFS
  | EBUSY
  | EAGAIN
  | EISCONN
  (* XXX: Hack to fix violation of errors specified in protocol *)
  | E2BIG
  | EPERM

(* Return the string representation of an error *)
let error_message error =
  match error with
  | EINVAL -> "EINVAL"
  | EACCES -> "EACCES"
  | EEXIST -> "EEXIST"
  | EISDIR -> "EISDIR"
  | ENOENT -> "ENOENT"
  | ENOMEM -> "ENOMEM"
  | ENOSPC -> "ENOSPC"
  | EIO -> "EIO"
  | ENOTEMPTY -> "ENOTEMPTY"
  | ENOSYS -> "ENOSYS"
  | EROFS -> "EROFS"
  | EBUSY -> "EBUSY"
  | EAGAIN -> "EAGAIN"
  | EISCONN -> "EISCONN"
  (* XXX: Hack to fix violation of errors specified in protocol *)
  | E2BIG -> "E2BIG"
  | EPERM -> "EPERM"

let message_error message =
  match message with
  | "EINVAL" -> EINVAL
  | "EACCES" -> EACCES
  | "EEXIST" -> EEXIST
  | "EISDIR" -> EISDIR
  | "ENOENT" -> ENOENT
  | "ENOMEM" -> ENOMEM
  | "ENOSPC" -> ENOSPC
  | "EIO" -> EIO
  | "ENOTEMPTY" -> ENOTEMPTY
  | "ENOSYS" -> ENOSYS
  | "EROFS" -> EROFS
  | "EBUSY" -> EBUSY
  | "EAGAIN" -> EAGAIN
  | "EISCONN" -> EISCONN
  (* XXX: Hack to fix violation of errors specified in protocol *)
  | "E2BIG" -> E2BIG
  | "EPERM" -> EPERM
  | _ -> raise Not_found

(* Error exception *)
exception Xs_error of error * string * string
