/******************************************************************************
 * tools/xenbaked.h
 *
 * Header file for xenbaked
 *
 * Copyright (C) 2005 by Hewlett Packard, Palo Alto and Fort Collins
 *
 * Authors: Diwaker Gupta, diwaker.gupta@hp.com
 *          Rob Gardner, rob.gardner@hp.com
 *          Lucy Cherkasova, lucy.cherkasova.hp.com
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; under version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __QOS_H__
#define __QOS_H__

///// qos stuff
#define million 1000000LL
#define billion 1000000000LL

#define QOS_ADD(N,A) ((N+A)<(NSAMPLES-1) ? (N+A) : A)
#define QOS_INCR(N) ((N<(NSAMPLES-2)) ? (N+1) : 0)
#define QOS_DECR(N) ((N==0) ? (NSAMPLES-1) : (N-1))

#define MAX_NAME_SIZE 32
#define IDLE_DOMAIN_ID 32767

/* Number of domains we can keep track of in memory */
#define NDOMAINS 8

/* Number of data points to keep */
#define NSAMPLES 100


// per domain stuff
typedef struct 
{
  u64 last_update_time;
  u64 start_time;		// when the thread started running
  u64 runnable_start_time;	// when the thread became runnable
  u64 blocked_start_time;	// when the thread became blocked
  u64 ns_since_boot;		// time gone by since boot
  u64 ns_oncpu_since_boot;	// total cpu time used by thread since boot
  //  u64 ns_runnable_since_boot;
  int runnable_at_last_update; // true if the thread was runnable last time we checked.
  int runnable;			// true if thread is runnable right now
  // tells us something about what happened during the 
  // sample period that we are analysing right now
  int in_use;			// 
  domid_t  id;
  char     name[MAX_NAME_SIZE];
} _domain_info;



typedef struct 
{
  struct 
  {
// data point:
//   stuff that is recorded once for each measurement interval
    u64 ns_gotten[NDOMAINS];		// ns used in the last sample period
    u64 ns_allocated[NDOMAINS];		// ns allocated by scheduler
    u64 ns_waiting[NDOMAINS];		// ns spent waiting to execute, ie, time from
                                        // becoming runnable until actually running
    u64 ns_blocked[NDOMAINS];		// ns spent blocked
    u64 switchin_count[NDOMAINS]; // number of executions of the domain	
    u64 io_count[NDOMAINS];
    u64 ns_passed;              // ns gone by on the wall clock, ie, the sample period
    u64 timestamp;
    u64 lost_records;		// # of lost trace records this time period
  } qdata[NSAMPLES];
  
  _domain_info domain_info[NDOMAINS];
  
  // control information
  int next_datapoint;

  // parameters
  int measurement_frequency;	// for example
  
  // feedback
  int dom0_invoke_counter;	// for example

} _new_qos_data;



#endif
